﻿using Microsoft.ML;

class Program
{
    static void Main(string[] args)
    {
        // 1) Tworzymy model
        MLContext mlContext = new MLContext();

        // 2) Wczytujemy dane
        string dataPath = "data.csv";
        IDataView dataView = mlContext.Data.LoadFromTextFile<FilmData>(
            path: dataPath,
            hasHeader: true,
            separatorChar: ','
        );

        // 3) Tworzymy pipelina:
        // - OneHotEncoding dla kolumny 'Gatunek' (zmiana tekstu na wartosci liczbowe)
        // - Concetenate do stworzenia wektora cech
        // - Trener binarnej klasyfikacji (SdcaLogisticRegression)
        var pipeline = mlContext.Transforms.Categorical.OneHotEncoding(
                                                            outputColumnName: "GatunekEncoded",
                                                            inputColumnName: "Gatunek"
                                                        )
                                                        .Append(mlContext.Transforms.Concatenate(
                                                            "Features",
                                                            "GatunekEncoded"
                                                        ))
                                                        .Append(mlContext.BinaryClassification.Trainers.SdcaLogisticRegression(
                                                            labelColumnName: nameof(FilmData.Lubiany),
                                                            featureColumnName: "Features"
                                                        ));
        // 4) Trening
        var model = pipeline.Fit(dataView);
        // 5) Zapisywanie modelu (opcjonalnie np. do pliku)
        mlContext.Model.Save(model, dataView.Schema, "ModelFilmy.zip");

        Console.WriteLine("Model wytrenowany!");

        var predEngine = mlContext.Model.CreatePredictionEngine<FilmData, FilmPrediction>(model);

        var nowyFilm = new FilmData
        {
            Tytul = "Testowa Akcja",
            Gatunek = "Akcja"
        };

        var wynik = predEngine.Predict(nowyFilm);

        Console.WriteLine($"Czy film '{nowyFilm.Tytul}' będzie lubiany? {wynik.Prediction} (Score: {wynik.Score})");
    }
}