using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class GameManager : MonoBehaviour
{
    // Start is called before the first frame update

    public Button resetButton;

    public Text scoreText;
    public static GameManager instance;

    public float worldScrollingSpeed = 0.2f;

    public float score = 0f;

    public bool inGame = true;
    void Start()
    {
        resetButton.gameObject.SetActive(false);
        if (instance == null)
        {
            instance = this;
        }
        inGame = true;
    }

    void FixedUpdate()
    {
        if (!inGame)
        {
            return;
        }
        score += worldScrollingSpeed;
        scoreText.text = score.ToString("0");
    }

    public void GameOver()
    {
        inGame = false;
        resetButton.gameObject.SetActive(true);
    }

    public void Restart()
    {
        inGame = true;
        // using UnityEngine.SceneManagement;
        SceneManager.LoadScene(0);
    }
}
