using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GhostChase : GhostBehaviour
{
    private void OnDisable()
    {
        if (Ghost.Scatter) Ghost.Scatter.Enable();
    }

    private void OnTriggerEnter2D(Collider2D collision)
    {
        // jeli zachowanie jest aktywne i zderzylimy si z obiektem posiadajcym skrypt Node
        if (enabled && collision.TryGetComponent(out Node node) && !Ghost.Frightened.enabled)
        {
            // domylny kierunek to (0,0)
            Vector2 direction = Vector2.zero;
            // min dystans - ustawiamy na najwikszy moliwy
            // tak aby pierwszy kierunek by od razu dotychczasow najlepsz opcj
            float minDistance = float.MaxValue;

            // dla kadego kierunku w obecnym wle
            foreach (Vector2 availableDirection in node.availableDirections)
            {
                // ustalamy now pozycj jako obecn przesunit o sprawdzany kierunek
                Vector3 newPosition = transform.position + new Vector3(availableDirection.x, availableDirection.y, 0f);
                // obliczamy dystans - uywamy sqrtMagnitude zamiast magnitude dla performance
                float distance = (Ghost.Target.position - newPosition).sqrMagnitude;

                // jeli obecny dystans jest mniejszy ni dotychczasowy najmniejszy
                // to ten kierunek powinen zbliy ducha do Pacmana bardziej
                if (distance < minDistance)
                {
                    // ustawiamy kierunek na sprawdzany kierunek
                    direction = availableDirection;
                    // ustawiamy min dystans na obecny dystans
                    minDistance = distance;
                }
            }

            // ustalenie kierunku na najlepszy
            Ghost.Movement.SetDirection(direction);
        }
    }
}
