using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using static Unity.IO.LowLevel.Unsafe.AsyncReadManagerMetrics;

public class GhostFrightened : GhostBehaviour
{
    [SerializeField] private SpriteRenderer normalBody;
    [SerializeField] private SpriteRenderer flashingBody;
    [SerializeField] private SpriteRenderer blueBody;

    [SerializeField] private SpriteRenderer eyesRenderer;

    private bool eaten;

    private void ShowGhostBody(SpriteRenderer bodyToShow)
    {
        SpriteRenderer[] bodies = { normalBody, flashingBody, blueBody };

        foreach (SpriteRenderer body in bodies)
        {
            body.enabled = (body == bodyToShow);
        }
    }

    public override void Enable(float duration)
    {
        base.Enable(duration);

        ShowGhostBody(blueBody);
        eyesRenderer.enabled = false;
        eaten = false;

        CancelInvoke(nameof(Flash));
        Invoke(nameof(Flash), duration / 2f);
        Ghost.Movement.SetSpeedMultiplier(0.5f);
    }

    private void Flash()
    {
        ShowGhostBody(flashingBody);
        eyesRenderer.enabled = false;
    }

    public override void Disable()
    {
        base.Disable();

        ShowGhostBody(normalBody);
        eyesRenderer.enabled = true;
        eaten = false;
        Ghost.Movement.SetSpeedMultiplier(1f);
    }

    private void GhostEaten()
    {
        eaten = true;
        Vector3 position = Ghost.Home.Inside.position;
        position.z = Ghost.transform.position.z;
        Ghost.transform.position = position;

        Ghost.Home.Enable(duration);
        GameManager.Instance.GhostEaten(Ghost);
    }

    private void OnCollisionEnter2D(Collision2D collision)
    {
        if (collision.gameObject.CompareTag(Pacman.PACMAN_TAG))
        {
            if (enabled)
            {
                GhostEaten();
            }
        }
    }

    private void OnTriggerEnter2D(Collider2D collision)
    {
        if (!eaten && enabled && collision.TryGetComponent(out Node node))
        {
            Vector2 direction = Vector2.zero;
            float maxDistance = float.MinValue; // zmieniamy nazw za pomoc refactor Rename z minDistance na maxDistance i zmieniamy warto na MinValue - najmniejsz moliw

            foreach (Vector2 availableDirection in node.availableDirections)
            {
                Vector3 newPosition = transform.position + new Vector3(availableDirection.x, availableDirection.y, 0f);
                float distance = (Ghost.Target.position - newPosition).sqrMagnitude;

                if (distance > maxDistance) // odwrcenie znaku!!
                {
                    direction = availableDirection;
                    maxDistance = distance;
                }
            }

            Ghost.Movement.SetDirection(direction);
        }
    }
}
