using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GhostScatter : GhostBehaviour
{
    private void OnDisable()
    {
        // do wczenia potem
        if (Ghost.Chase != null) Ghost.Chase.Enable();
    }

    private void OnTriggerEnter2D(Collider2D collision)
    {
        // jeli aktywny (OnTriggerEnter moe aktywowa si nawet jeli zachowanie nie jest aktywne)
        // i jeli nie jest przestraszony oraz wszed w kollider Node'a
        if (enabled && collision.TryGetComponent(out Node node) && !Ghost.Frightened.enabled)
        {
            // losujemy index kierunku z listy dostepnych w danym skrzyowaniu/nodzie
            int index = Random.Range(0, node.availableDirections.Count);

            // zapobieganie zawracaniu - jeli wybralimy kierunek wstecz/zmieniamy na kolejny
            // tylko jeli jest inna cieka (w poziomie nie ma slepych uliczek, nie powinna taka sytuacja zaj)
            if (node.availableDirections[index] == -Ghost.Movement.direction && node.availableDirections.Count > 1)
            {
                index++;

                if (index >= node.availableDirections.Count)
                {
                    index = 0;
                }
            }

            // ustalamy kierunek - nastpny do obrania bo dopiero wchodzimy na wze
            Ghost.Movement.SetDirection(node.availableDirections[index]);
        }
    }
}
