import pygame
from random import choice, randint 

pygame.init() # inicjalizacja

# rozmiar okna
SCREEN_WIDGHT = 800
SCREEN_HIGHT = 600
FPS = 60

screen_surface = pygame.display.set_mode((SCREEN_WIDGHT,SCREEN_HIGHT)) # rozmiar okna 
pygame.display.set_caption("Pierwsza gra") # nadanie nazwy oknu
clock = pygame.time.Clock()

def load_image(img_path: str, position): #f: zaladowanie obrazka
    image = pygame.image.load(img_path)
    surface = image.convert()
    transparent_colour = (0,0,0) # przezroczysty kolor to 0, 0, 0 czyli czarny
    surface.set_colorkey(transparent_colour) 
    # pozycja wyświetlanego obiektu
    rect = surface.get_rect(center=position)
    return [image, surface, rect]
    
def print_image(img_list) -> None: # f: wyswietlenie obrazka
    image, surface, rect = img_list
    screen_surface.blit(surface, rect)
    pass

def set_position_image(img_list, position):
    image, surface, rect = img_list
    rect = surface.get_rect(center=position) # pozycja prostokata (tyle ile podalismy)
    return [image, surface, rect]

def calculate_player_mowement(keys):
    speed = 25
    delta_x = 0
    delta_y = 0
    if keys[pygame.K_w]:
        delta_y -= speed 
        pass
    if keys[pygame.K_s]:
        delta_y += speed 
        pass
    if keys[pygame.K_a]:
        delta_x -= speed 
        pass
    if keys[pygame.K_d]:
        delta_x += speed
        pass
    return [delta_x,delta_y]    

def limits_position(position):
    x , y = position 
    x = max(0, min(x, SCREEN_WIDGHT))
    y = max(0, min(y, SCREEN_HIGHT))
    return [x, y]

def generate_bonus_object():
    image_name = choice(bonus_images) # losowanie obrazka bonusu
    x = randint(0, SCREEN_WIDGHT)
    y = randint(0, SCREEN_HIGHT)
    position = [x, y]
    new_object = load_image(image_name, position)
    bonus_objects.append(new_object)
    pass
def print_bonus_object():
    for obj in bonus_objects:
        print_image(obj)
        pass
    pass
def check_collision():
    rect_player = player[2]
    for i in range(len(bonus_objects)-1,-1,-1):
        obj = bonus_objects[i]
        rect = obj[2]
        if rect.colliderect(rect_player): # if dotyka bonus
            bonus_objects.pop(i) # wyrzuć obiekt

######################################################################

player_pos = [SCREEN_WIDGHT//2, SCREEN_HIGHT//2]
player = load_image("player.png", player_pos)

bonus_images = ["bonus_1.png","bonus_2.png","bonus_3.png"] # obrazki bonusów
bonus_objects = []                                         # lista przechowująca obiekty bonusowe

backround_colour = [0,0,0]
# zmienna określająca czy okno ma być otwarte
game_status = True

frame_cnt = 0
######################################################################

# praktycznie w każdej grze "while ..."
while game_status:
    frame_cnt += 1
    events = pygame.event.get() # pobranie eventów
    for event in events:
        if event.type == pygame.QUIT: # zamknięcie gry po X
            game_status = False       
    pressed_keys = pygame.key.get_pressed()        

    delta_x, delta_y = calculate_player_mowement(pressed_keys) # wyznaczenie zmiany pozycji
    player_pos[0] += delta_x # zmiana poz na niby
    player_pos[1] += delta_y # zmiana poz na niby
    player_pos = limits_position(player_pos)
    player = set_position_image(player,player_pos) # pr poz

    screen_surface.fill(backround_colour) # tło
    print_image(player) # rys playera
    
    if frame_cnt % FPS == 0:
        generate_bonus_object() # wyswietlanie bonusowych obiektow
        pass
    check_collision()
    print_bonus_object()    #
    
    pygame.display.update() # spr. czy coś się dzieje
    clock.tick(FPS) #fps
    pass


pygame.quit()
quit()