import pygame
from kierunek import Kierunek


class Waz(pygame.sprite.Sprite):
    def __init__(self):
        super().__init__()
        self.obraz_bazowy = pygame.image.load("images/head.png")
        self.obraz = pygame.transform.rotate(self.obraz_bazowy, 0)
        self.kierunek = Kierunek.GÓRA

        x = 8 * 32
        y = 8 * 32
        self.rect = pygame.Rect(x, y, 32, 32)

    def obróć(self, kierunek):
        self.kierunek = kierunek
        self.obraz = pygame.transform.rotate(self.obraz_bazowy, kierunek.value * 90)
        
    def rusz(self):
        match self.kierunek:
            case Kierunek.PRAWO:
                self.rect.move_ip(32, 0)
            case Kierunek.GÓRA:
                self.rect.move_ip(0, -32)
            case Kierunek.DÓŁ:
                self.rect.move_ip(0, 32)
            case Kierunek.LEWO:
                self.rect.move_ip(-32, 0)